$(function() {
    initBanner();
    fullHeightCols();
    // ScrollTo
    scrollTo();
    // If there is a hash, scroll to it
    // Only on homepage
    if(window.location.hash && !$('.header.static').length) {
        p = $(window.location.hash).position().top - 130;
        $.scrollTo(p + 'px', 250);
        return false;
    }
});

function scrollTo() {
    $('a').click(function(){
        // Only scroll if there is only a hash on the link
        if(this.hash.substring(0,1) == '#') {
            p = $(this.hash).position().top - 130;
            $.scrollTo(p + 'px', 250);
            return false;
        }
    });
}

function initBanner() {
    if($('.header.home').length > 0) {
        var scrollTop;
        var kpmgTop = $('.home #kpmg-banner').css('top').replace('px','');
        $(window).scroll(function() {
            // distance between banner and top of window
            scrollTop = $(window).scrollTop();
            if(scrollTop > kpmgTop) {
                $('.home #kpmg-banner').css({position: 'fixed', top: 0 });
            }
            else {
                // bottom of banner
                var headerHeight = $('.header.home').height() - 3;
                $('.home #kpmg-banner').css({position: 'absolute', top: headerHeight + 'px'});
            }
            
            // title text
            if(scrollTop > 20) {
                $('.home #title').css({position: 'fixed', top: '10px' });
            }
            else {
                $('.home #title').css({position: 'absolute', top: '40px' });
            }
        });
    }
    // Mobile
    /*if($('.mobile-header').length > 0) {
        var scrollTop;
        var kpmgTop = $('.mobile-header').css('top').replace('px','');
        $(window).scroll(function() {
            // distance between banner and top of window
            scrollTop = $(window).scrollTop();
            if(scrollTop > kpmgTop) {
                $('.mobile-header').css({position: 'fixed', top: 0 });
            }
            else {
                // bottom of banner
                var headerHeight = $('.header.mobile').height() - 3;
                $('.mobile-header').css({position: 'absolute', top: headerHeight + 'px'});
            }
        });
    }*/
}

function fullHeightCols() {
    $('#side-nav').height($(window).height());
    var documentHeight = $(document).height();
    //alert($(document).height());
    //alert($('#kpmg-banner').height() + $('.header').height());
    var mainHeight = documentHeight - $('#kpmg-banner').height() - 120 - $('.header').height();
    if($('.home .side').height() < mainHeight) {
            $('.home .side').height(mainHeight);   
    }
    
}